/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile'
	, 'hbs!applets/wound-care-applet/templates/riskContent'
	, 'hbs!applets/wound-care-applet/templates/empty' ],
	function (Portal, Backbone, Marionette, $, _, jqm, template, emptyTemplate) {
		'use strict';
		var $collapses, that, indices, shouldSubmit, timer,$savePopup, showSaved;
//		Portal.module('WoundCareApplet', function (WoundCareApplet, Portal, Backbone, Marionette, $, _, template) {
//			WoundCareApplet.RiskFactorsView =
		return Backbone.Marionette.ItemView.extend({
				className: "applet scrollable",
				id:'wound-care',
				events: {
					'click #save': 'saveEvent',
					'autosave': "autosaveEvent"
//					,
//					'write-to-note': 'disableInputs'
				},
				template : template,
				initialize:function(options){
					showSaved = (this.model.get('riskFactorAssessment') &&
						this.model.get('riskFactorAssessment').saved);
					that = this;
					that.vent = options.vent || new Backbone.Wreqr.EventAggregator();
					that.listenTo(that.vent, 'note-writer-close', that.enableView  );
					that.listenTo(that.vent, 'note-writer-open', that.disableView );
					// TODO: Oh my
					if( $("#clinic-event.ui-panel-open").length === 1  )
					{
						that.disableView();
					}
					indices = ['alterationsInSensation','alterationsInMobility','frictionOrShear',
						'alterationInNutritionOrHydration','moisture','otherDiagnoses','devicesAndEquipment'];
				},
				disableView:function(){
					console.log("disable forms");
					this.template = emptyTemplate;
					this.render();this.onShow();
				},
				enableView:function(){
					console.log("ebable forms");
					this.template = template;
					this.render();this.onShow();
				},
				onShow: function () {

					shouldSubmit = false;
					//that.disableInputs();
					$('#applet-title h2').html('Additional Risk Factors');
					this.$el.trigger('create');
					$collapses = $('[data-role="collapsible"]');
					this.vent.trigger("show");
					if (showSaved)
						$savePopup=$('#risk-factor-saved-popup');
					else
						$savePopup = $('<div data-role="popup" id="risk-factor-saved-popup" data-inline="true" data-overlay-theme="a" class="wc-popup"><a href="#" data-rel="back" data-role="button" data-theme="a" data-icon="delete" data-iconpos="notext" class="ui-btn-right">Close popup</a><p class="wc-subtitle">Assessment Saved</p></div>');
					$savePopup.on('popupafteropen',function() {
						$savePopup.find('[data-icon="delete"]').focus();
					});
					$savePopup.on('popupafterclose',function(){$savePopup.popup('destroy');
						$savePopup.remove();});
				},
				autosaveEvent:function(){
					shouldSubmit = false;
					that.save();
				},
				disableInputs:function(){
					if (this.model.get('riskFactorAssessment').status === 'WRITTEN_TO_NOTE') {
						this.$el.find('input').prop('disabled',true);
						this.$el.find('textarea').prop('disabled',true);
						this.$el.find('button').prop('disabled',true);
					}
				},
				savePopup: function() {
					that.$el.append($savePopup);
					$savePopup.trigger('create');
					$savePopup.popup();
					$savePopup.popup('open');
				},
				onClose: function (){
					$savePopup.off('popupafteropen');
					$savePopup.off('popupafterclose');
					clearInterval( timer );
				},
				saveEvent:function(e){
					shouldSubmit = true;
					this.savePopup();
					this.save();
				},
				save: function() {
					var tempAssessment = this.model.get('riskFactorAssessment');
					_.each($('input:not(:checked)'), function(n) {
						var $n = $(n);
						if (tempAssessment[$n.attr('name')]) {
							_.each(tempAssessment[$n.attr('name')],function(item){
								if (item && $n.data('label').indexOf(item.value) !== -1){
									tempAssessment[$n.attr('name')].splice(tempAssessment[$n.attr('name')].indexOf(item),1);
									item.datetime = null;
									item.value = null;
								}

							});
						}
					});
					_.each($('input:checked'),function(i) {

						var $i = $(i), obj;
						if (!tempAssessment[$i.attr('name')]) {
							tempAssessment[$i.attr('name')] = [];
							obj = {value: $i.data('label')};
							tempAssessment[$i.attr('name')].push(obj);
						}
						else {
							var usable = true;
							_.each(tempAssessment[$i.attr('name')], function(ele) {
								if (ele.value === $i.data('label')) {
									usable = false;
									return false; //the item exists
								}
							});
							if (usable){
								obj = {value: $i.data('label')};
								tempAssessment[$i.attr('name')].push(obj);
							}
						}
					});
					if (shouldSubmit)
						tempAssessment.status = "UPDATED";
					else
						tempAssessment.status = "ACTIVE";
					this.model.set({
						riskFactorAssessment:tempAssessment
					});
					this.model.save({},{
						success: function() {
							if (shouldSubmit)
								window.location.hash = '#risk-factors/saved';
						},
						fail: function() {
							console.log('failure to save');
						},
						error: function() {
							console.log('error saving');
						}
					});
				},
				templateHelpers: function () {
					if (showSaved)
						return this.formDataSaved();
					return this.formDataSaved();
				},
				formDataSaved: function(){
					var inData = this.formData();
					var outData = this.formData();
					_.each(indices, function(el){
						outData.factors[el].none = false;
						_.each(inData.factors[el].section, function(subel, index) {
							if (that.model.get('riskFactorAssessment') &&
									that.model.get('riskFactorAssessment')[el]) {
								_.each(that.model.get('riskFactorAssessment')[el],function(ele) {
									if (ele.value.indexOf(subel.label) !== -1) {
										outData.factors[el].section[index].selected = true;
										outData.factors[el].none = true;
									}
								});
							} else {
								outData.factors[el].section[index].selected = false;
							}
						});
					});
					return outData;
				},
				formData: function() {
					var ret = {
						'factors': {
							'alterationsInSensation' : {
								name:'Alterations in Sensation',
								id:'alterationsInSensation',
								section: [
									{id:'diabetes', label: 'Diabetes Mellitus'},
									{id:'peripheral-neuropathy' ,label: 'Peripheral neuropathy'},
									{id:'cva', label: 'CVA'},
									{id:'sci-d', label: 'SCI/D'},
									{id:'postoperative-period', label: 'Postoperative period'},
									{id:'post-anesthesia', label: 'Post Anesthesia'},
									{id:'sedatives', label: 'Sedatives'},
									{id:'als', label: 'ALS'}
								]
							},
							'alterationsInMobility' : {
								name:'Alterations in Mobility',
								id:'alterationsInMobility',
								section: [
									{id:'fracture', label: 'Fracture'},
									{id:'amputation', label: 'Amputation'},
									{id:'soft-tissue-injury', label: 'Soft tissue injury'},
									{id:'frail-elder', label: 'Frail elder'},
									{id:'muscular-atrophy', label: 'Muscular atrophy'},
									{id:'pain', label: 'Pain'},
									{id:'advanced-age', label: 'Advanced age'}
								]
							},
							'frictionOrShear' : {
								name: 'Friction or Shear',
								id:'frictionOrShear',
								section: [
									{id:'poor-posture', label: 'Poor posture'},
									{id:'spasticity', label: 'Spasticity'},
									{id:'head-of-bed', label: 'Head of bed elevation'}
								]
							},
							'alterationInNutritionOrHydration' : {
								name:'Alterations in Nutrition or Hydration',
								id:'alterationInNutritionOrHydration',
								section: [
									{id:'change-weight', label: 'Increase or decrease in weight'},
									{id:'protein-malnutrition', label: 'Protein calorie malnutrition'},
									{id:'dehydration', label: 'Dehydration'}
								]
							},
							'moisture' : {
								name: 'Moisture',
								id:'moisture',
								section: [
									{id:'edema', label: 'Edema'},
									{id:'perspiration', label: 'Excessive perspiration'}
								]
							},
							'otherDiagnoses' : {
								name: 'Other Diagnoses',
								id:'otherDiagnoses',
								section: [
									{id:'renal-disease', label: 'End stage renal disease'},
									{id:'chf', label: 'CHF'},
									{id:'pvd', label: 'PVD'},
									{id:'immune-deficiency', label: 'Immune deficiency'},
									{id:'malignancies', label: 'Malignancies'},
									{id:'cpod', label: 'COPD'},
									{id:'contractures', label: 'Contractures'},
									{id:'infection', label: 'Infection'},
									{id:'tobacco-use', label: 'Tobacco use'},
									{id:'chemotherapy', label: 'Chemotherapy'}
								]
							},
							'devicesAndEquipment' : {
								name: 'Devices and Equipment',
								id:'devicesAndEquipment',
								section: [
									{id:'catheters', label: 'Catheters'},
									{id:'cpap', label: 'CPAP'},
									{id:'bipap', label: 'BiPAP'},
									{id:'securing-devices', label: 'Securing devices'},
									{id:'splints', label: 'Splints'},
									{id:'adaptive-equipment', label: 'Adaptive equipment'},
									{id:'restraints ', label: 'Restraints '}
								]
							}
						}
					};


					_.each(indices, function(el){
						_.each(ret.factors[el].section, function(subel, index) {

							if (that.model.get('riskFactorAssessment') &&
								that.model.get('riskFactorAssessment')[el]) {
								_.each(that.model.get('riskFactorAssessment')[el], function(ele) {
									if (ele.value.indexOf(subel.label) !== -1 && ele.datetime)
										ret.factors[el].section[index].past = that.formatDate(ele.datetime);
								});
								//ret.factors[el].section[index].past = that.model.get('pastRiskFactorAssessment').updateDate;
							}
						});
					});
					return ret;
				},
				formatDate: function(str) {
					var splitt = str.split('.')[0].replace('T', ' ').split('-');
					return splitt[1] + '/' + splitt[2].split(':')[0] + ':' + splitt[2].split(':')[1];
				}
			});
//		}, template);
	});